﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Threading;
using Futronic.SDKHelper;
using System.Windows.Forms;

namespace FS28BluetoothMasterModeDemo
{
    public class Identify
    {
        /// <summary>
        /// A directory name to write user's information.
        /// </summary>
        private String m_DatabaseDir;
       /// <summary>
        /// Contain reference for current operation object
        /// </summary>
        private FutronicSdkBase m_Operation = null;

        public Identify()
        {
            try
            {
                m_DatabaseDir = GetDatabaseDir();
            }
            catch (IOException)
            {
                MessageBox.Show(null, "Initialization failed. Application will be close.\nCan not create database folder",
                    null, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }
        }

        public void StartIdentify(byte[]Sample)
        {
            List<DbRecord> Users = DbRecord.ReadRecords( m_DatabaseDir );
            if (Users.Count == 0)
            {
                MessageBox.Show(null, "Users not found. Please, run enrollment process first.", null, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }
            if (m_Operation != null)
            {
                m_Operation.Dispose();
                m_Operation = null;
            }
            m_Operation = new FutronicIdentification();
            m_Operation.FARN = 245;

            ((FutronicIdentification)m_Operation).BaseTemplate = Sample;        
            

            int iRecords = 0;
            int nResult;
            StringBuilder szMessage = new StringBuilder();
            FtrIdentifyRecord[] rgRecords = new FtrIdentifyRecord[Users.Count];
            foreach (DbRecord item in Users)
            {
                rgRecords[iRecords] = item.GetRecord();
                iRecords++;
            }
            nResult = ((FutronicIdentification)m_Operation).Identification(rgRecords, ref iRecords);
            if (nResult == FutronicSdkBase.RETCODE_OK)
            {
                szMessage.Append("Identification complete. User: ");
                if (iRecords != -1)
                    szMessage.Append(Users[iRecords].UserName);
                else
                    szMessage.Append("not found");
            }
            else
            {
                szMessage.Append("Identification failed.");
                szMessage.Append(FutronicSdkBase.SdkRetCode2Message(nResult));
            }
            MessageBox.Show(null, szMessage.ToString(), "Identify result", MessageBoxButtons.OK, MessageBoxIcon.Information);
            if (m_Operation != null)
            {
                m_Operation.Dispose();
            }
        }
        /// <summary>
        /// Get the database directory.
        /// </summary>
        /// <returns>returns the database directory.</returns>
        public static String GetDatabaseDir()
        {
            String szDbDir;
            szDbDir = Path.Combine(Directory.GetCurrentDirectory(), "Database");
            if (!Directory.Exists(szDbDir))
            {
                Directory.CreateDirectory(szDbDir);
            }

            return szDbDir;
        }

    }
}
